package dicts

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

// TODO(u-jeen): когда сделаем RASPTICKETS-22376, перевести работу со справочниками на единую библиотеку
type CarriersRepository struct {
	baseRepository  *repository.CarrierRepository
	carrierIDByIATA map[string]int32
}

func NewCarriersRepository() *CarriersRepository {
	return &CarriersRepository{
		baseRepository:  repository.NewCarrierRepository(),
		carrierIDByIATA: make(map[string]int32),
	}
}

func (cr *CarriersRepository) Write(b []byte) (int, error) {
	carrier := &rasp.TCarrier{}
	if err := proto.Unmarshal(b, carrier); err != nil {
		return 0, fmt.Errorf("CarrierRepository:Write: %w", err)
	}
	cr.baseRepository.Add(carrier)
	cr.carrierIDByIATA[carrier.Iata] = carrier.Id
	return len(b), nil
}

func (cr *CarriersRepository) Get(id int) (*rasp.TCarrier, bool) {
	carrier, found := cr.baseRepository.Get(id)
	return carrier, found
}

func (cr *CarriersRepository) GetByIata(code string) (int32, bool) {
	carrier, found := cr.carrierIDByIATA[code]
	return carrier, found
}

func (cr *CarriersRepository) Add(carrier *rasp.TCarrier) {
	cr.baseRepository.Add(carrier)
}

func (cr *CarriersRepository) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewCarriersRepository()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*cr = *newState
	return nil
}

func (cr *CarriersRepository) Size() int {
	return len(cr.carrierIDByIATA)
}
