package dicts

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

// TODO(u-jeen): когда сделаем RASPTICKETS-22376, перевести работу со справочниками на единую библиотеку
type CountriesRepository struct {
	baseRepository *repository.CountryRepository
}

func NewCountriesRepository() *CountriesRepository {
	return &CountriesRepository{
		baseRepository: repository.NewCountryRepository(),
	}
}

func (cr *CountriesRepository) Write(b []byte) (int, error) {
	country := &rasp.TCountry{}
	if err := proto.Unmarshal(b, country); err != nil {
		return 0, fmt.Errorf("CountryRepository:Write: %w", err)
	}
	cr.baseRepository.Add(country)
	return len(b), nil
}

func (cr *CountriesRepository) Get(id int32) (*rasp.TCountry, bool) {
	country, found := cr.baseRepository.Get(id)
	return country, found
}

func (cr *CountriesRepository) Add(country *rasp.TCountry) {
	cr.baseRepository.Add(country)
}

func (cr *CountriesRepository) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewCountriesRepository()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*cr = *newState
	return nil
}
