package dicts

import (
	"fmt"

	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/travel/library/go/dicts/repository"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
)

// TODO(u-jeen): когда сделаем RASPTICKETS-22376, перевести работу со справочниками на единую библиотеку
type StationsRepository struct {
	baseRepository *repository.StationRepository
}

func NewStationsRepository() *StationsRepository {
	return &StationsRepository{
		baseRepository: repository.NewStationRepository(),
	}
}

func (cr *StationsRepository) Write(b []byte) (int, error) {
	station := &rasp.TStation{}
	if err := proto.Unmarshal(b, station); err != nil {
		return 0, fmt.Errorf("StationRepository:Write: %w", err)
	}
	cr.baseRepository.Add(station)
	return len(b), nil
}

func (cr *StationsRepository) Get(id int) (*rasp.TStation, bool) {
	station, found := cr.baseRepository.Get(id)
	return station, found
}

func (cr *StationsRepository) Add(station *rasp.TStation) {
	cr.baseRepository.Add(station)
}

func (cr *StationsRepository) UpdateFromSource(iterator RepositoryUpdater) error {
	newState := NewStationsRepository()
	if err := iterator.Populate(newState); err != nil {
		return err
	}
	*cr = *newState
	return nil
}
