package dump

import (
	"encoding/json"
	"net/http"

	"github.com/go-chi/chi/v5"
	"github.com/opentracing/opentracing-go"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/storage"
	"a.yandex-team.ru/travel/library/go/httputil"
)

type DumpHandler struct {
	storage storage.Storage
	logger  log.Logger
}

func NewDumpHandler(storage storage.Storage, logger log.Logger) *DumpHandler {
	return &DumpHandler{storage: storage, logger: logger}
}

func (h *DumpHandler) Handle(w http.ResponseWriter, r *http.Request) {
	span, _ := opentracing.StartSpanFromContext(
		r.Context(),
		"internal.services.fare_families.handler.http:DumpHandler",
	)
	defer span.Finish()

	form := &DumpHandlerForm{}
	if err := form.Bind(r); err != nil {
		httputil.HandleError(err, http.StatusBadRequest, w)
		return
	}

	result, err := h.storage.GetDump(form.Carrier, form.fareFamilyFilters...)
	if err != nil {
		httputil.HandleError(err, http.StatusInternalServerError, w)
		return
	}
	resultBytes, err := json.Marshal(result)
	if err != nil {
		httputil.HandleError(err, http.StatusInternalServerError, w)
		return
	}
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(http.StatusOK)
	_, _ = w.Write(resultBytes)
}

func (h *DumpHandler) GetRouteBuilder() func(r chi.Router) {
	return func(r chi.Router) {
		r.Get("/fare-families/dump", h.Handle)
	}
}
