package dump

import (
	"net/http"
	"regexp"
	"strconv"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/storage"
	tariffmatcher "a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/tariff_matcher"
)

const (
	CaseInsensitivePrefix = "(?i)"
)

type DumpHandlerForm struct {
	Carrier           int32 `json:"carrier"`
	fareFamilyFilters []storage.FareFamilyFilterFunc
}

func (f *DumpHandlerForm) Bind(r *http.Request) error {
	f.fareFamilyFilters = []storage.FareFamilyFilterFunc{}

	query := r.URL.Query()
	carrier := query.Get("carrier")
	if carrier == "" {
		return xerrors.New("Missing \"carrier\" field")
	}
	carrierID, err := strconv.Atoi(carrier)
	if err != nil {
		return xerrors.Errorf("Invalid \"carrier\" field: %w", err)
	}
	f.Carrier = int32(carrierID)

	brand := query.Get("brand")
	if len(brand) > 0 {
		r, err := regexp.Compile(CaseInsensitivePrefix + brand)
		if err != nil {
			return xerrors.Errorf("Invalid \"brand\" regexp %s: %w", brand, err)
		}
		f.fareFamilyFilters = append(f.fareFamilyFilters, tariffmatcher.NewFareFamilyFilterByBrand(r))
	}

	tariffCode := query.Get("tariff_code")
	if len(tariffCode) > 0 {
		f.fareFamilyFilters = append(f.fareFamilyFilters, tariffmatcher.NewFareFamilyFilterByTariffCode(tariffCode))
	}

	return nil
}
