package dump

import (
	"encoding/json"
	"net/http"

	"github.com/go-chi/chi/v5"
	"github.com/opentracing/opentracing-go"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/storage"
	"a.yandex-team.ru/travel/library/go/httputil"
)

type FilesListHandler struct {
	storage storage.Storage
	logger  log.Logger
}

func NewFilesListHandler(storage storage.Storage, logger log.Logger) *FilesListHandler {
	return &FilesListHandler{storage: storage, logger: logger}
}

func (h *FilesListHandler) Handle(w http.ResponseWriter, r *http.Request) {
	span, _ := opentracing.StartSpanFromContext(
		r.Context(),
		"internal.services.fare_families.handler.http:FilesListHandler",
	)
	defer span.Finish()

	resultBytes, err := json.Marshal(h.storage.GetFiles())
	if err != nil {
		httputil.HandleError(err, http.StatusInternalServerError, w)
		return
	}
	w.Header().Set("Content-Type", "application/json")
	w.WriteHeader(http.StatusOK)
	_, _ = w.Write(resultBytes)
}

func (h *FilesListHandler) GetRouteBuilder() func(r chi.Router) {
	return func(r chi.Router) {
		r.Get("/fare-families/files", h.Handle)
	}
}
