package tariff

import (
	"net/http"

	"a.yandex-team.ru/library/go/core/xerrors"
	farefamiliesstructs "a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/data_structs/fare_families"
	"a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/data_structs/payloads"
)

type TariffHandlerPayload struct {
	VariantsFromPartner []payloads.VariantsFromPartner `json:"variants"`
}

type TariffHandlerResponse struct {
	FareFamiliesMap []payloads.FareFamiliesMap `json:"data"`
}

type TariffDebugHandlerResponse struct {
	FareFamily farefamiliesstructs.FareFamilyForVariant `json:"fare-family"`
}

type TariffDebugHandlerForm struct {
	Carrier   string `json:"carrier"`
	FareCode  string `json:"farecode"`
	From      string `json:"from"`
	To        string `json:"to"`
	Departure string `json:"departure"`
}

func (f *TariffDebugHandlerForm) Bind(r *http.Request) error {
	query := r.URL.Query()
	f.Carrier = query.Get("carrier")
	if len(f.Carrier) == 0 {
		return xerrors.New("Missing \"carrier\" field")
	}

	f.FareCode = query.Get("farecode")
	if len(f.FareCode) == 0 {
		return xerrors.New("Missing \"farecode\" field")
	}

	f.From = query.Get("from")
	if len(f.From) == 0 {
		return xerrors.New("Missing \"from\" field")
	}

	f.To = query.Get("to")
	if len(f.To) == 0 {
		return xerrors.New("Missing \"to\" field")
	}

	f.Departure = query.Get("departure")
	if len(f.Departure) == 0 {
		return xerrors.New("Missing \"departure\" field")
	}

	return nil
}
