package storage

import (
	"strconv"
	"strings"
)

const (
	UnknownCarryOnBucketSize = "unknown"
	SmallCarryOnBucketSize   = "small"
	RegularCarryOnBucketSize = "regular"

	MinRegularCarryOnSize = 50
)

func GetCarryOnSizeBucket(carryOnSize string) string {
	if len(carryOnSize) == 0 {
		return UnknownCarryOnBucketSize
	}
	carryOnSize = strings.ReplaceAll(carryOnSize, "х", "x")
	sizeParts := strings.Split(carryOnSize, "x")
	for _, part := range sizeParts {
		intValue, err := strconv.Atoi(part)
		if err != nil {
			return UnknownCarryOnBucketSize
		}
		if intValue >= MinRegularCarryOnSize {
			return RegularCarryOnBucketSize
		}
	}
	return SmallCarryOnBucketSize
}
