package tariffmatcher

import (
	farefamiliesstructs "a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/data_structs/fare_families"
)

type chargeMap map[string]chargeValue

var chargesTerms = []string{farefamiliesstructs.RefundableCode, farefamiliesstructs.ChangingCarriageCode}

func (cm chargeMap) updateWorstCharges(updatedFareFamily *farefamiliesstructs.FareFamilyForVariant) {
	if updatedFareFamily == nil {
		return
	}

	for _, term := range updatedFareFamily.Terms {
		for _, termCode := range chargesTerms {
			if term.Code != termCode {
				continue
			}
			currentCharge, ok := cm[termCode]
			newCharge := newChargeValue(term.Rule)
			if !ok {
				cm[termCode] = newCharge
				continue
			}
			cm[termCode] = worseCharge(currentCharge, newCharge)
		}
	}
}

func calculateTotalCharges(chargesPerCarrier map[int32]chargeMap) chargeMap {
	result := chargeMap{}
	for _, charges := range chargesPerCarrier {
		for _, termCode := range chargesTerms {
			newCharges, ok := charges[termCode]
			if !ok {
				continue
			}
			currentCharges, ok := result[termCode]
			if !ok {
				result[termCode] = newCharges
				continue
			}
			result[termCode] = addCharge(currentCharges, newCharges)
		}
	}
	return result
}
