package tariffmatcher

import (
	"regexp"

	farefamiliesstructs "a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/data_structs/fare_families"
	"a.yandex-team.ru/travel/avia/fare_families/internal/services/fare_families/storage"
)

var regexpCache = NewRegexpCache()

func NewFareFamilyFilterByBrand(r *regexp.Regexp) storage.FareFamilyFilterFunc {
	return func(fareFamily farefamiliesstructs.CompiledFareFamily) bool {
		return r.MatchString(fareFamily.Brand)
	}
}

func NewFareFamilyFilterByTariffCode(tariffCode string) storage.FareFamilyFilterFunc {
	return func(fareFamily farefamiliesstructs.CompiledFareFamily) bool {
		if fareFamily.TariffCodeRegExp != nil {
			result := regexpCache.MatchString(fareFamily.TariffCodeRegExp, tariffCode)
			if fareFamily.NegateRegexp {
				return !result
			}
			return result
		}
		return true
	}
}
