package controllers

import (
	"net/http"
	"time"

	"a.yandex-team.ru/travel/avia/feature_flag_api/internal/controllers/response"
	"a.yandex-team.ru/travel/avia/feature_flag_api/internal/indexbuilder"
	"a.yandex-team.ru/travel/avia/feature_flag_api/internal/models"
)

type IndexGetter interface {
	GetCurrentIndex() *indexbuilder.Index
}

func GetByCode(indexGetter IndexGetter, params map[string][]string) (int, interface{}) {
	index := indexGetter.GetCurrentIndex()

	if index == nil {
		return http.StatusServiceUnavailable, &response.FailFeatureFlag{
			Message: "Index is not ready",
		}
	}

	codes, has := params["service-code"]
	if !has {
		return http.StatusBadRequest, &response.FailFeatureFlag{
			Message: "service_code is required parameter",
		}
	}

	code := codes[0]
	service, hasService := index.ServiceByCode[code]
	if !hasService {
		return http.StatusBadRequest, &response.FailFeatureFlag{
			Message: "Unknown services",
		}
	}

	flagIds := index.FlagIdsByServiceID[service.ID]

	return http.StatusOK, &response.FeatureFlag{
		Flags:      getFlags(index, flagIds, models.Enable),
		ABFlags:    getFlags(index, flagIds, models.UseAB),
		LastUpdate: index.LastUpdate.Format(time.RFC3339),
	}
}

func getFlags(
	index *indexbuilder.Index,
	flagIds map[int]bool,
	state models.FeatureFlagState,
) []string {
	flags := make([]string, 0)
	for flagID := range flagIds {
		featureFlag, has := index.FlagByID[flagID]
		if has && featureFlag.State == state {
			flags = append(flags, featureFlag.Code)
		}
	}
	return flags
}
