package dataprovider

import (
	"database/sql"

	"a.yandex-team.ru/travel/avia/feature_flag_api/internal/models"
)

type FlagProvider struct{}
type IFlagProvider interface {
	Fetch(con *sql.DB) ([]*models.FeatureFlag, error)
}

func NewFlagProvider() *FlagProvider {
	return &FlagProvider{}
}

func (*FlagProvider) Fetch(con *sql.DB) ([]*models.FeatureFlag, error) {
	var m []*models.FeatureFlag

	rows, err := con.Query(
		"select id, code, enabled FROM feature_flag_app__feature_flag")
	if err != nil {
		return nil, err
	}

	for rows.Next() {
		var id int
		var code string
		var state models.FeatureFlagState

		err = rows.Scan(&id, &code, &state)
		if err != nil {
			return nil, err
		}

		m = append(m, &models.FeatureFlag{
			ID:    id,
			Code:  code,
			State: state,
		})
	}

	return m, nil
}
