package dataprovider

import (
	"database/sql"

	"a.yandex-team.ru/travel/avia/feature_flag_api/internal/models"
)

type RelationsProvider struct{}
type IRelationsProvider interface {
	Fetch(con *sql.DB) ([]*models.ServiceFeatureFlagRelation, error)
}

func NewRelationsProvider() *RelationsProvider {
	return &RelationsProvider{}
}

func (*RelationsProvider) Fetch(con *sql.DB) ([]*models.ServiceFeatureFlagRelation, error) {
	var m []*models.ServiceFeatureFlagRelation

	rows, err := con.Query(
		"select service_id, feature_flag_id FROM " +
			"feature_flag_app__service_feature_flag_relation")
	if err != nil {
		return nil, err
	}

	for rows.Next() {
		var serviceID int
		var featureFlagID int

		err = rows.Scan(&serviceID, &featureFlagID)
		if err != nil {
			return nil, err
		}

		m = append(m, &models.ServiceFeatureFlagRelation{
			ServiceID:     serviceID,
			FeatureFlagID: featureFlagID,
		})
	}

	return m, nil
}
