package dataprovider

import (
	"database/sql"
	"fmt"

	"a.yandex-team.ru/travel/avia/feature_flag_api/internal/models"
)

type ServiceProvider struct{}
type IServiceProvider interface {
	Fetch(con *sql.DB) ([]*models.Service, error)
}

func NewServiceProvider() *ServiceProvider {
	return &ServiceProvider{}
}

func (p *ServiceProvider) Fetch(con *sql.DB) ([]*models.Service, error) {
	var m []*models.Service

	rows, err := con.Query(
		"select id, code FROM feature_flag_app__service")
	if err != nil {
		return nil, fmt.Errorf("querying: %+v", err)
	}

	for rows.Next() {
		var id int
		var code string

		err = rows.Scan(&id, &code)
		if err != nil {
			return nil, fmt.Errorf("scaning: %+v", err)
		}

		m = append(m, &models.Service{
			ID:   id,
			Code: code,
		})
	}

	return m, nil
}
