package db

import (
	"bytes"
	"database/sql"
	_ "github.com/go-sql-driver/mysql"
	"math/rand"
	"text/template"
	"time"
)

type ConnectionConfig struct {
	Slaves   []string
	UserName string
	Password string
	Protocol string
	Port     int
	Schema   string
}

type dsn struct {
	Host     string
	UserName string
	Password string
	Protocol string
	Port     int
	Schema   string
}

type Connector struct{}

type IConnector interface {
	Connect(d *ConnectionConfig) (*sql.DB, error)
}

func New() *Connector {
	return &Connector{}
}

func (*Connector) Connect(d *ConnectionConfig) (*sql.DB, error) {
	dsnString, err := getDSNString(d)
	if err != nil {
		return nil, err
	}

	return sql.Open("mysql", dsnString)
}

var compiledTemplate *template.Template

func getDSNString(config *ConnectionConfig) (string, error) {
	var DsnString bytes.Buffer

	d := dsn{
		randomHost(config.Slaves),
		config.UserName,
		config.Password,
		config.Protocol,
		config.Port,
		config.Schema,
	}

	if compiledTemplate == nil {
		dsnTemplate := "{{.UserName}}:{{.Password}}@{{.Protocol}}({{.Host}}:{{.Port}})/{{.Schema}}?charset=utf8&parseTime=true&loc=Local"

		var err error
		compiledTemplate, err = template.New("DSN template").Parse(dsnTemplate)
		if err != nil {
			return "", err
		}
	}

	_ = compiledTemplate.Execute(&DsnString, d)

	return DsnString.String(), nil
}

func randomHost(hosts []string) string {
	rand.Seed(time.Now().Unix())
	i := rand.Intn(len(hosts))

	return hosts[i]
}
