package environmentvariableprovider

import (
	"fmt"
	"os"

	"a.yandex-team.ru/travel/avia/feature_flag_api/internal/baseerror"
)

type EnvironmentVariableProvider struct {
	prefix string
}

type IEnvironmentVariableProvider interface {
	ReadRequiredEnv(name string) (string, error)
	ReadEnv(name string) string
}

func New() *EnvironmentVariableProvider {
	return &EnvironmentVariableProvider{
		prefix: "AVIA_FEATURE_FLAG_API_",
	}
}

func (p *EnvironmentVariableProvider) getFullVariableName(name string) string {
	return p.prefix + name
}

func (p *EnvironmentVariableProvider) ReadRequiredEnv(name string) (string, error) {
	fullVariableName := p.getFullVariableName(name)
	value, has := os.LookupEnv(fullVariableName)

	if !has {
		return "", &baseerror.BaseError{
			Message: fmt.Sprintf(
				"Environment variable [%v] does not set",
				fullVariableName,
			),
		}
	}

	return value, nil
}

func (p *EnvironmentVariableProvider) ReadEnv(name string) string {
	fullVariableName := p.getFullVariableName(name)
	return os.Getenv(fullVariableName)
}
