from cached_property import cached_property
from sqlalchemy import create_engine
from sqlalchemy.engine import Engine
from sqlalchemy.orm import sessionmaker, Session

from travel.avia.flight_extras.settings import PGAAS_MASTER_QUERY, PGAAS_MASTER_QUERY_RO


class DB(object):
    def __init__(self, connection_string, autocommit=False):
        # type: (str, bool) -> None
        self._connection_string = connection_string
        self._autocommit = autocommit

    @cached_property
    def engine(self):
        # type: () -> Engine
        return create_engine(
            self._connection_string,
            echo=False,
            use_batch_mode=True,
        )

    @cached_property
    def _session_factory(self, **kwargs):
        # type: (dict) -> sessionmaker
        return sessionmaker(bind=self.engine, **kwargs)

    def create_session(self, **kwargs):
        # type: (dict) -> Session
        autocommit = kwargs.get('autocommit', self._autocommit)
        return self._session_factory(autocommit=autocommit, **kwargs)


db_master = DB(PGAAS_MASTER_QUERY, autocommit=False)
db_slave = DB(PGAAS_MASTER_QUERY_RO, autocommit=True)
