import os

import tornado
from raven.contrib.tornado import SentryMixin
from tornado.web import RequestHandler


class PingHandler(SentryMixin, RequestHandler):
    def get(self):
        self.write('OK')


class VersionHandler(SentryMixin, RequestHandler):
    def get(self):
        self.set_header('Content-Type', 'text/plain')
        self.write('Tornado version: {}\n'.format(tornado.version))
        self.write('Package tag: {}\n'.format(os.getenv('QLOUD_DOCKER_IMAGE')))
        self.write('Package hash: {}\n'.format(os.getenv('QLOUD_DOCKER_HASH')))
