"""init

Revision ID: a30c83ad5963
Revises: 
Create Date: 2018-01-10 11:09:09.287318+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'a30c83ad5963'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('flight',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('company_iata', sa.String(), nullable=False),
    sa.Column('number', sa.String(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('company_iata', 'number', name='ui_flight')
    )
    op.create_table('version',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('source', sa.String(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text(u'now()'), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('flight_passenger_experience',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('flight_id', sa.BigInteger(), nullable=False),
    sa.Column('departure_day', sa.Date(), nullable=False),
    sa.Column('version_id', sa.BigInteger(), nullable=False),
    sa.Column('airport_from', sa.String(), nullable=True),
    sa.Column('airport_to', sa.String(), nullable=True),
    sa.Column('departure_time', sa.String(), nullable=True),
    sa.Column('arrival_time', sa.String(), nullable=True),
    sa.Column('extra_day', sa.SmallInteger(), nullable=True),
    sa.Column('aircraft', sa.String(), nullable=True),
    sa.Column('seats_total', sa.SmallInteger(), nullable=True),
    sa.Column('seats_first_class', sa.SmallInteger(), nullable=True),
    sa.Column('seats_business_class', sa.SmallInteger(), nullable=True),
    sa.Column('seats_comfort', sa.SmallInteger(), nullable=True),
    sa.Column('seats_economy', sa.SmallInteger(), nullable=True),
    sa.Column('wifi_first_class', sa.Boolean(), nullable=True),
    sa.Column('wifi_business', sa.Boolean(), nullable=True),
    sa.Column('wifi_comfort', sa.Boolean(), nullable=True),
    sa.Column('wifi_economy', sa.Boolean(), nullable=True),
    sa.Column('power_first_class', sa.Boolean(), nullable=True),
    sa.Column('power_business', sa.Boolean(), nullable=True),
    sa.Column('power_comfort', sa.Boolean(), nullable=True),
    sa.Column('power_economy', sa.Boolean(), nullable=True),
    sa.Column('ife_first_class', sa.Boolean(), nullable=True),
    sa.Column('ife_business', sa.Boolean(), nullable=True),
    sa.Column('ife_comfort', sa.Boolean(), nullable=True),
    sa.Column('ife_economy', sa.Boolean(), nullable=True),
    sa.Column('seat_pitch_first_class', sa.SmallInteger(), nullable=True),
    sa.Column('seat_pitch_business', sa.SmallInteger(), nullable=True),
    sa.Column('seat_pitch_comfort', sa.SmallInteger(), nullable=True),
    sa.Column('seat_pitch_economy', sa.SmallInteger(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['flight_id'], [u'flight.id'], ),
    sa.ForeignKeyConstraint(['version_id'], [u'version.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('flight_passenger_experience')
    op.drop_table('version')
    op.drop_table('flight')
    # ### end Alembic commands ###
