"""flight info from sky guru

Revision ID: 2bb81bfaeaac
Revises: 9ef679547472
Create Date: 2018-04-27 19:58:18.010836+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '2bb81bfaeaac'
down_revision = '9ef679547472'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('flight_info',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('flight_id', sa.BigInteger(), nullable=False),
    sa.Column('departure_day', sa.Date(), nullable=False),
    sa.Column('turbulence_index', sa.SmallInteger(), nullable=True),
    sa.Column('direct_distance', sa.Integer(), nullable=True),
    sa.Column('distance', sa.Integer(), nullable=True),
    sa.Column('average_speed', sa.SmallInteger(), nullable=True),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('turbulence_zones', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('route', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('sun', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('wind', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('weather_from', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('weather_to', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('sights', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('aircraft', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('airport_from', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('airport_to', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text(u'now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.ForeignKeyConstraint(['flight_id'], [u'flight.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('flight_id', 'departure_day', name='ui_flight_info')
    )
    op.drop_index('idx_flight_id_departure_day_version_id_desc', table_name='flight_passenger_experience')
    op.create_index('idx_flight_id_departure_day_version_id_desc', 'flight_passenger_experience', ['flight_id', 'departure_day', sa.text(u'version_id desc')], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('idx_flight_id_departure_day_version_id_desc', table_name='flight_passenger_experience')
    op.create_index('idx_flight_id_departure_day_version_id_desc', 'flight_passenger_experience', ['flight_id', 'departure_day', 'version_id'], unique=False)
    op.drop_table('flight_info')
    # ### end Alembic commands ###
