"""source

Revision ID: fb01ff550f78
Revises: 2bb81bfaeaac
Create Date: 2019-08-07 18:34:02.797328+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'fb01ff550f78'
down_revision = '2bb81bfaeaac'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('idx_flight_id_departure_day_version_id_desc', table_name='flight_passenger_experience')
    op.drop_constraint(u'flight_passenger_experience_version_id_fkey', 'flight_passenger_experience', type_='foreignkey')
    op.drop_column('flight_passenger_experience', 'version_id')
    op.drop_table('version')

    op.create_table(
        'source',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('name', sa.String(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text(u'now()'), nullable=False),
        sa.PrimaryKeyConstraint('id'),
        sa.UniqueConstraint('name')
    )
    op.add_column('flight_passenger_experience', sa.Column('source_id', sa.BigInteger(), nullable=False))
    op.create_unique_constraint('ui_flight_departure_day', 'flight_passenger_experience', ['flight_id', 'departure_day'])
    op.create_foreign_key(None, 'flight_passenger_experience', 'source', ['source_id'], ['id'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('flight_passenger_experience', sa.Column('version_id', sa.BIGINT(), autoincrement=False, nullable=False))
    op.drop_constraint(None, 'flight_passenger_experience', type_='foreignkey')
    op.create_foreign_key(u'flight_passenger_experience_version_id_fkey', 'flight_passenger_experience', 'version', ['version_id'], ['id'])
    op.create_index('idx_flight_id_departure_day_version_id_desc', 'flight_passenger_experience', ['flight_id', 'departure_day', 'version_id'], unique=False)
    op.drop_constraint('ui_flight_departure_day', 'flight_passenger_experience', type_='unique')
    op.drop_column('flight_passenger_experience', 'source_id')
    op.create_table('version',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('source', sa.VARCHAR(), autoincrement=False, nullable=True),
    sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text(u'now()'), autoincrement=False, nullable=False),
    sa.PrimaryKeyConstraint('id', name=u'version_pkey')
    )
    op.drop_table('source')
    # ### end Alembic commands ###
