import logging
import os
import sys
from logging.config import dictConfig

from cloud_logger import default_config
from travel.library.python.avia_mdb_replica_info.avia_mdb_replica_info import MdbAPI, POSTGRES_API_BASE_URL

os.environ['REQUESTS_CA_BUNDLE'] = '/etc/ssl/certs/ca-certificates.crt'

DEBUG = os.getenv('AVIA_DEBUG', 'false') == 'true'

LOG_PATH = os.getenv('AVIA_LOG_PATH', '/ephemeral/var/log/yandex-flight-extras')

WORKERS = int(os.getenv('AVIA_TORNADO_WORKERS', 1))
SOCKET_PATH = os.getenv('AVIA_TORNADO_SOCKET', '/tmp/flight-extras.sock')

SENTRY_URL = os.getenv('AVIA_SENTRY_URL', None)
AVIA_BACKEND_URL = os.getenv('AVIA_BACKEND_URL', None)

REST_DATETIME_FORMAT = '%Y-%m-%dT%H:%M:%S'
REST_DATE_FORMAT = '%Y-%m-%d'

FLIGHT_STORAGE_API_URL = os.getenv(
    'AVIA_FLIGHT_STORAGE_API_URL', 'http://flight-storage.unstable.avia.yandex.net/api/v1'
)
SKY_GURU_API_URL = os.getenv('AVIA_SKY_GURU_API_URL', 'http://[64:ff9b::194.87.210.68]/commercialapi/v0.4')
SKY_GURU_AUTH_TOKEN = os.getenv('AVIA_SKY_GURU_AUTH_TOKEN')
SKY_GURU_FETCH_LIMIT = int(os.getenv('AVIA_SKY_GURU_FETCH_LIMIT', 10))

PGAAS_CLUSTER_ID = os.getenv('AVIA_PGAAS_CLUSTER_ID')
if PGAAS_CLUSTER_ID:
    PGAAS_DATABASE_NAME = os.getenv('AVIA_PGAAS_DATABASE_NAME')
    PGAAS_USER = os.getenv('AVIA_PGAAS_USER')
    PGAAS_PASSWORD = os.getenv('AVIA_PGAAS_PASSWORD')
    PGAAS_PORT = os.getenv('AVIA_PGAAS_PORT', '6432')

    mdb_api = MdbAPI(
        api_base_url=POSTGRES_API_BASE_URL,
        oauth_token=os.getenv('AVIA_MDB_API_TOKEN'),
    )
    mdb_api.add_default_cluster_info(
        cluster_id=PGAAS_CLUSTER_ID,
        master_hostname='c-{}.rw.db.yandex.net'.format(PGAAS_CLUSTER_ID),
        hostnames=['c-{}.ro.db.yandex.net'.format(PGAAS_CLUSTER_ID)],
    )
    cluster_info = mdb_api.get_cluster_info(PGAAS_CLUSTER_ID)
    cluster_info.sort_replicas_by_dc(os.getenv('CURRENT_DC'))

    PGAAS_MASTER_QUERY = cluster_info.psycopg2_connection_string(
        user=PGAAS_USER,
        password=PGAAS_PASSWORD,
        database=PGAAS_DATABASE_NAME,
        port=PGAAS_PORT,
        sslmode='require',
        target_session_attrs='read-write',
    )
    PGAAS_MASTER_QUERY_RO = cluster_info.psycopg2_connection_string(
        user=PGAAS_USER,
        password=PGAAS_PASSWORD,
        database=PGAAS_DATABASE_NAME,
        port=PGAAS_PORT,
        sslmode='require',
        target_session_attrs='any',
    )
    PGAAS_MASTER_MIGRATION = PGAAS_MASTER_QUERY
else:
    PGAAS_MASTER_QUERY_RO = PGAAS_MASTER_QUERY = os.getenv('AVIA_PGAAS_MASTER_QUERY')
    PGAAS_MASTER_MIGRATION = os.getenv('AVIA_PGAAS_MASTER_MIGRATION')


def setup_logging():
    dictConfig(default_config(LOG_PATH))
    if SENTRY_URL:
        from raven.conf import setup_logging
        from raven.handlers.logging import SentryHandler
        sentry_handler = SentryHandler(SENTRY_URL)
        sentry_handler.setLevel(logging.WARNING)
        setup_logging(sentry_handler)

    if DEBUG:
        root = logging.getLogger()
        root.setLevel(logging.INFO)
        handler = logging.StreamHandler(sys.stdout)
        handler.setLevel(logging.INFO)
        root.addHandler(handler)
