import logging

import tornado
from tornado.web import Application, RequestHandler

from travel.avia.flight_status_fetcher.settings.app import DOCKER_HASH, DOCKER_IMAGE
from travel.avia.flight_status_fetcher.worker import update_sever_aero

logger = logging.getLogger(__name__)


class PingHandler(RequestHandler):
    def get(self):
        self.write('OK')


class SeverAeroHandler(RequestHandler):
    def _run(self):
        logger.info('Scheduling Sever Aero update.')
        update_sever_aero.apply_async()
        logger.info('Sever Aero update scheduled.')
        self.write('OK')

    def get(self):
        self._run()

    def post(self):
        self._run()


class VersionHandler(RequestHandler):
    def get(self):
        self.set_header('Content-Type', 'text/plain')
        self.write('Tornado version: {}\n'.format(tornado.version))
        self.write('Package tag: {}\n'.format(DOCKER_IMAGE))
        self.write('Package hash: {}\n'.format(DOCKER_HASH))


def create_application(debug=False):
    return Application(
        [
            (r'/ping', PingHandler),
            (r'/version', VersionHandler),
            (r'/sever-aero', SeverAeroHandler),
        ],
        debug=debug,
    )
