import logging

import tornado
import tornado.process
from tornado.httpserver import HTTPServer
from tornado.ioloop import IOLoop
from tornado.netutil import bind_unix_socket
from tornado.options import define, options

from travel.avia.flight_status_fetcher.api import create_application
from travel.avia.flight_status_fetcher.settings.app import API_SOCKET_PATH, API_WORKERS
from travel.avia.flight_status_fetcher.library.logging import setup_logging

logger = logging.getLogger()

define('debug', default=False, help='Debug mode')


def main():
    setup_logging()
    application = create_application(debug=options.debug)
    sockets = [bind_unix_socket(API_SOCKET_PATH, 0o666)]
    if API_WORKERS == 1:
        server = HTTPServer(application)
        server.add_sockets(sockets)
        server.start()
    else:
        tornado.process.fork_processes(API_WORKERS)
        server = HTTPServer(application)
        server.add_sockets(sockets)
    IOLoop.current().start()


if __name__ == '__main__':
    options.parse_command_line()
    logger.info('Tornado version: {}'.format(tornado.version))
    logger.info('Debug: {}'.format(options.debug))

    main()
