import argparse
import logging

from travel.avia.library.python.iata_correction import IATACorrector
from travel.avia.library.python.shared_dicts.cache.company_cache import CompanyCache

from travel.avia.flight_status_fetcher.library.airport_updater import AirportUpdater
from travel.avia.flight_status_fetcher.library.flight_number_parser import FlightNumberParser
from travel.avia.flight_status_fetcher.settings.services import shared_flights
from travel.avia.flight_status_fetcher.library.logging import setup_logging

RESTART_EVERY = 60


def main():
    setup_logging()
    parser = argparse.ArgumentParser()
    parser.add_argument('airport', help='Airport code')
    parser.add_argument('--statuses', action='store_true', help='Print statuses')

    program_args = parser.parse_args()

    airport = str(program_args.airport).lower()

    logger = logging.getLogger(__name__ + airport)

    iata_corrector = IATACorrector(
        shared_flights.SHARED_FLIGHTS_API_BASE_URL,
        logger,
    )

    companies = CompanyCache(logger)
    companies.populate()

    flight_number_parser = FlightNumberParser(companies, iata_corrector)

    updater = AirportUpdater(logger, flight_number_parser)
    statuses = updater.collect_statuses(airport)

    if program_args.statuses:
        print(statuses)


if __name__ == '__main__':
    main()
