import logging
import os
from logging.config import dictConfig

from cloud_logger import default_config

from travel.avia.flight_status_fetcher.settings.app import LOG_PATH, DEBUG, SENTRY_URL


def setup_logging():
    if LOG_PATH:
        os.makedirs(LOG_PATH, exist_ok=True)
    log_config = default_config(LOG_PATH)
    if DEBUG:
        log_config['root']['level'] = 'DEBUG'
        for handler in log_config['handlers'].values():
            handler['level'] = 'DEBUG'
    dictConfig(log_config)
    if SENTRY_URL:
        from raven.conf import setup_logging
        from raven.handlers.logging import SentryHandler

        sentry_handler = SentryHandler(SENTRY_URL)
        sentry_handler.setLevel(logging.WARNING)
        setup_logging(sentry_handler)
    kikimr_logger = logging.getLogger('kikimr')
    kikimr_logger.setLevel(logging.FATAL)
    kikimr_logger.handlers = []
