import logging

import ujson
import requests

from travel.avia.flight_status_fetcher.settings.services import solomon

logger = logging.getLogger(__name__)


def transform_dict_to_sensors(timestamp, dct):
    return [
        {
            'labels': {
                'sensor': key,
            },
            'ts': timestamp,
            'value': value,
        }
        for key, value in dct.items()
    ]


def upload_to_solomon(common_labels, sensors, try_count=3):
    """
    Загружает в solomon список сенсоров через Push API
    """
    if not solomon.SOLOMON_URL:
        logger.warning('No solomon url provided. Metrics won\'t be sent')
        return

    if not solomon.SOLOMON_TOKEN:
        logger.warning('No solomon token provided. Metrics won\'t be sent')
        return

    solomon_json = {
        'commonLabels': common_labels,
        'sensors': sensors,
    }

    headers = {
        'Content-type': 'application/json',
        'Authorization': 'OAuth {}'.format(solomon.SOLOMON_TOKEN),
    }

    for i in range(try_count):
        try:
            response = requests.post(
                solomon.SOLOMON_URL,
                params={
                    'project': solomon.SOLOMON_PROJECT,
                    'cluster': solomon.SOLOMON_CLUSTER,
                    'service': solomon.SOLOMON_SERVICE,
                },
                data=ujson.dumps(solomon_json),
                headers=headers,
                timeout=solomon.SOLOMON_TIMEOUT,
            )
            response.raise_for_status()
            break
        except Exception:
            if i == try_count - 1:
                raise


def _push_time(project, cluster, service, sensor_name, timestamp, value):
    common_labels = {
        'project': project,
        'cluster': cluster,
        'service': service,
    }

    sensors = [
        {
            'labels': {
                'sensor': sensor_name,
            },
            'value': value,
            'ts': timestamp,
        }
    ]

    upload_to_solomon(common_labels, sensors)
