from abc import ABC, abstractmethod
from typing import Any, Dict


class ObjectWithStatistics(ABC):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._last_run_statistics = {}

    @abstractmethod
    def _clear_statistics(self) -> None:
        """Reset _last_run_statistics"""

    @property
    def statistics(self) -> Dict[Any, Any]:
        return self._last_run_statistics
