import os

from travel.avia.flight_status_fetcher.settings.env import ENVIRONMENT

DEBUG = bool(os.getenv('DEBUG', False))

DOCKER_IMAGE = os.getenv('DEPLOY_DOCKER_IMAGE')
DOCKER_HASH = os.getenv('DEPLOY_DOCKER_HASH')

LOG_PATH = os.getenv('AVIA_LOG_PATH')
SENTRY_URL = os.getenv('AVIA_SENTRY_URL')

AIRPORT_IMPORTER_RETRY_SETTINGS = dict(
    total=5,
    read=5,
    connect=5,
    backoff_factor=0.3,
    status_forcelist=(404, 500, 502, 503, 504),
)

API_WORKERS = int(os.getenv('AVIA_TORNADO_WORKERS', 1))
API_SOCKET_PATH = os.getenv('AVIA_TORNADO_SOCKET', '/tmp/flight-status-fetcher.sock')

if ENVIRONMENT != 'dev':
    assert DOCKER_IMAGE
    assert DOCKER_HASH
    assert LOG_PATH
    assert SENTRY_URL
else:
    LOG_PATH = 'log'
