import os
from http import HTTPStatus
from travel.avia.flight_status_fetcher.settings.env import ENVIRONMENT

AVIA_BACKEND_BASE_URL = os.getenv('AVIA_BACKEND_BASE_URL')
AVIA_BACKEND_RETRY = dict(  # urllib.Retry parameters
    total=5, backoff_factor=0.5, status_forcelist=[status.value for status in HTTPStatus if status.value >= 500]
)
AVIA_BACKEND_TIMEOUT = 60
AVIA_BACKEND_REFRESH_REFERENCE_TIMEOUT = 2 * 60 * 60  # 2 часа


if ENVIRONMENT != 'dev':
    assert AVIA_BACKEND_BASE_URL
else:
    AVIA_BACKEND_BASE_URL = 'http://backend.testing.avia.yandex.net'
