import os

from travel.avia.library.python.proxy_pool.deploy_proxy_pool import DeployProxyPool

from travel.avia.flight_status_fetcher.settings.env import CURRENT_DC, YANDEX_ENVIRONMENT_TYPE

AVIA_PARTNER_PROXY_LOGIN = os.getenv('AVIA_PARTNER_PROXY_LOGIN')
AVIA_PARTNERS_PROXY_PASSWORD = os.getenv('AVIA_PARTNER_PROXY_PASSWORD')

if bool(AVIA_PARTNER_PROXY_LOGIN) != bool(AVIA_PARTNERS_PROXY_PASSWORD):
    raise ValueError('AVIA_PARTNER_PROXY_LOGIN and AVIA_PARTNERS_PROXY_PASSWORD should be specified at the same time')

if AVIA_PARTNER_PROXY_LOGIN and AVIA_PARTNERS_PROXY_PASSWORD:
    PARTNERS_PROXY_POOL = DeployProxyPool(
        environment=YANDEX_ENVIRONMENT_TYPE,
        datacenter=CURRENT_DC,
        login=AVIA_PARTNER_PROXY_LOGIN,
        password=AVIA_PARTNERS_PROXY_PASSWORD,
    )
else:
    PARTNERS_PROXY_POOL = None
