import os
from http import HTTPStatus

from travel.avia.flight_status_fetcher.settings.env import ENVIRONMENT

SHARED_FLIGHTS_API_BASE_URL = os.getenv('AVIA_SHARED_FLIGHTS_API_BASE_URL')

SHARED_FLIGHTS_API_RETRY = dict(  # urllib.Retry parameters
    total=5, backoff_factor=0.5, status_forcelist=[status.value for status in HTTPStatus if status.value >= 500]
)
SHARED_FLIGHTS_API_TIMEOUT = 60  # 60 seconds

if ENVIRONMENT != 'dev':
    assert SHARED_FLIGHTS_API_BASE_URL
else:
    SHARED_FLIGHTS_API_BASE_URL = 'http://shared-flights.testing.avia.yandex.net/api/v1'
