import os

from travel.avia.flight_status_fetcher.settings.env import ENVIRONMENT


def _get_solomon_cluster():
    if ENVIRONMENT == 'dev':
        return ENVIRONMENT

    return os.getenv('AVIA_SOLOMON_CLUSTER', 'dev')


SOLOMON_URL = 'https://solomon.yandex.net/api/v2/push'
SOLOMON_PROJECT = 'avia'
SOLOMON_SERVICE = 'flight_status_fetcher'
SOLOMON_CLUSTER = _get_solomon_cluster()
SOLOMON_TOKEN = os.getenv('AVIA_SOLOMON_TOKEN')
SOLOMON_TIMEOUT = 15

if ENVIRONMENT != 'dev':
    assert SOLOMON_TOKEN
