import os

from travel.avia.flight_status_fetcher.settings.env import ENVIRONMENT

LED_FTP_HOST = os.getenv('LED_FTP_HOST', 'ftp2.pulkovo-airport.com')
LED_FTP_USER = os.getenv('LED_FTP_USER', 'schedulexml')
LED_FTP_PASSWORD = os.getenv('LED_FTP_PASSWORD')
LED_ARRIVAL_DATA_FILENAME = os.getenv('LED_ARRIVAL_DATA_FILENAME', 'ARR.xml')
LED_DEPARTURE_DATA_FILENAME = os.getenv('LED_DEPARTURE_DATA_FILENAME', 'DEP.xml')
LED_TIMEOUT = float(os.getenv('LED_FTP_TIMEOUT', '10').replace(',', '.'))
LED_RETRY_SETTINGS = dict(
    stop_max_attempt_number=int(os.getenv('LED_FTP_MAX_ATTEMPTS', '10')),
    wait_exponential_multiplier=100,  # (2**<repeats>)*100ms
    wait_exponential_max=10000,  # 10 seconds
)

if ENVIRONMENT != 'dev':
    assert LED_FTP_PASSWORD
