from travel.avia.flight_status_fetcher import common
from travel.avia.flight_status_fetcher.services import avia_backend


class AviaBackendMock(avia_backend.AviaBackend):
    def __init__(self):
        super().__init__('', {}, 0)
        self.iata_by_aero_name = {common.canonical_name_ru('Усть-Нера'): 'USR'}
        self.sirena_by_aero_name = {
            'внуково': 'VKO',
            'маган': 'МГН',
            'мома': 'МОМ',
            'олекминск': 'ОЛК',
            'оленек': 'ОЛН',
            'северо-эвенск': 'СВЕ',
            'таймылыр': 'ТМЛ',
            'усть-нера': 'УНР',
            'чайбуха': 'ЧБХ',
        }
        self.iata_by_city_name = {
            'белая гора': 'BGN',
            'иркутск': 'IKT',
            'красноярск': 'KJA',
            'мирный': 'MJZ',
            'новосибирск': 'OVB',
            'якутск': 'YKS',
            'магадан': 'GDX',
        }
        self.sirena_by_city_name = {
            'айхал': 'АХЛ',
            'батагай': 'BTG',
            'белая гора': 'БЯГ',
            'верхневилюйск': 'ВХВ',
            'вилюйск': 'ВИК',
            'витим': 'ВИМ',
            'депутатский': 'ДЕП',
            'жиганск': 'ЖИГ',
            'зырянка': 'ЗНК',
            'иркутск': 'ИКТ',
            'красноярск': 'КЯА',
            'ленск': 'ЛСК',
            'мирный': 'МИР',
            'накын': 'НКН',
            'нерюнгри': 'НРГ',
            'новосибирск': 'ОВБ',
            'нюрба': 'НЮР',
            'олёкминск': 'ОЛК',
            'полярный': 'ПЛЯ',
            'саккырыр': 'СКЫ',
            'сангар': 'САГ',
            'саскылах': 'СЫХ',
            'среднеколымск': 'СРМ',
            'сунтар': 'СУН',
            'тикси': 'ТСИ',
            'усть-куйга': 'УКУ',
            'усть-мая': 'УСМ',
            'усть-нера': 'УНР',
            'хандыга': 'ХДЫ',
            'черский': 'ЧРС',
            'чокурдах': 'ЧКД',
            'якутск': 'ЯКТ',
            'магадан': 'МДН',
        }
        self.airline_id_by_sirena = {
            'ЯК': 16,
        }
        self.airline_id_by_iata = {}
