PY3TEST(flights)

OWNER(g:avia)

PEERDIR(
    contrib/python/Faker
    contrib/python/pytest
    contrib/python/requests-mock
    contrib/python/mock

    travel/avia/flight_status_fetcher
)

PY_SRCS(
    __init__.py
    avia_backend_mock.py
    test_sources/helpers.py
    test_sources/test_dme/conftest.py
    test_sources/test_dme/factories.py
)

TEST_SRCS(
    test_common.py
    test_library/test_raw_data.py
    test_sources/test_basel_aero/test_get_flights.py
    test_sources/test_basel_aero/test_normalize_checkin_desks.py
    test_sources/test_dme/test_get_dme_flights.py
    test_sources/test_dme/test_get_flights.py
    test_sources/test_led/test_get_flights.py
    test_sources/test_region_airports/test_get_flights.py
    test_sources/test_region_airports/test_configuration.py
    test_sources/test_sever_aero/test_schedule.py
    test_sources/test_sever_aero/test_sever_aero.py
    test_sources/test_svo/test_get_flights.py
    test_sources/test_vko/test_get_flights.py
)

DATA(
    arcadia/travel/avia/flight_status_fetcher
)

RESOURCE_FILES(
    resources/subjects.xml
    resources/timetable.xml
    test_sources/test_basel_aero/response.xml
    test_sources/test_region_airports/response_goj.xml
    test_sources/test_region_airports/response_kuf.xml
    test_sources/test_region_airports/response_nux.xml
    test_sources/test_region_airports/response_rov.xml
    test_sources/test_region_airports/response_svx.xml
)

SIZE(SMALL)

END()
