"""
Функции для безопасного парсинга xml
https://wiki.yandex-team.ru/security/for/developers#xxe
"""
from lxml import etree


class FakeDTDResolver(etree.Resolver):
    def resolve(self, url, id, context):
        return self.resolve_string('', context)


def get_xml_safe_parser(**kwargs):
    for key, value in {
        'remove_blank_text': True,
        'resolve_entities': False,
        'load_dtd': False,
        'no_network': True,
    }.items():
        kwargs.setdefault(key, value)
    parser = etree.XMLParser(**kwargs)
    parser.resolvers.add(FakeDTDResolver())
    return parser


def safe_parse_xml(filepath, **kwargs):
    return etree.parse(filepath, parser=get_xml_safe_parser(**kwargs))


def safe_xml_fromstring(text, **kwargs):
    return etree.fromstring(text, parser=get_xml_safe_parser(**kwargs))
