PY3_LIBRARY()

OWNER(g:avia)

PEERDIR(
    contrib/python/boto3
    contrib/python/celery
    contrib/python/ipython
    contrib/python/lxml
    contrib/python/parsel
    contrib/python/pytz
    contrib/python/raven
    contrib/python/requests
    contrib/python/retrying
    contrib/python/tornado/tornado-6
    contrib/python/ujson
    contrib/python/urllib3
    contrib/python/zeep

    travel/avia/flight_status_fetcher/settings
    travel/avia/flight_status_fetcher/settings/services
    travel/avia/flight_status_fetcher/settings/sources

    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/iata_correction
    travel/avia/library/python/proxy_pool
    travel/avia/library/python/shared_dicts

    travel/library/python/cloud_logger
    travel/library/python/logbroker
)

PY_SRCS(
    api.py
    common.py
    const.py
    ftp_wrapper.py
    library/airport_importer.py
    library/airport_updater.py
    library/feature_flag.py
    library/flight_number_parser.py
    library/logging.py
    library/raw_data.py
    library/solomon.py
    library/statistics.py
    services/api.py
    services/avia_backend.py
    services/logbroker.py
    services/status.py
    sources/basel/__init__.py
    sources/dme/__init__.py
    sources/led/__init__.py
    sources/region_airports/__init__.py
    sources/sever_aero/__init__.py
    sources/sever_aero/schedule.py
    sources/sever_aero/timetable.py
    sources/svo/__init__.py
    sources/vko/__init__.py
    updaters.py
    utils/import_helper.py
    utils/safe_xml_parser.py
    utils/wsdl.py
    utils/xml.py
    worker.py
)

END()

RECURSE(
    bin
)

RECURSE_FOR_TESTS(
    tests
)
