package main

import (
	"fmt"
	"net/http"

	"github.com/go-chi/chi/v5"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/library/go/handlers"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

func runChiServer(port int, handlers ...handlers.Handler) {
	router := chi.NewRouter()

	for _, handler := range handlers {
		router.Mount(handler.GetRoute(), handler)
	}
	logger.Logger().Info(
		"Running server",
		log.Int("port", port),
		log.Reflect("handlers", handlers),
	)
	logger.Logger().Fatal("Server error",
		log.Error(
			http.ListenAndServe(
				fmt.Sprintf(":%d", port),
				router,
			),
		),
	)
}
