package main

import (
	"a.yandex-team.ru/library/go/core/log"
	arczap "a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/travel/avia/flight_status_receiver/internal/app"
	"a.yandex-team.ru/travel/avia/flight_status_receiver/internal/config"
	"a.yandex-team.ru/travel/avia/flight_status_receiver/internal/handlers"
	"a.yandex-team.ru/travel/avia/flight_status_receiver/internal/shutdown"
	aviaHandlers "a.yandex-team.ru/travel/avia/library/go/handlers"
	aviaLogging "a.yandex-team.ru/travel/avia/library/go/logging"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

func main() {
	conf := config.NewConfig()
	go runProfiler(conf.HTTP.ProfilerPort)
	configureLogging(&conf.Logging)
	configureMetrics(conf.HTTP)
	shutdownService := configureShutdown(conf.HTTP)

	App, err := app.NewAppP(conf)
	if err != nil {
		logger.Logger().Fatal("Cannot create app", log.Error(err))
	}

	runChiServer(
		conf.HTTP.AppPort,
		handlers.PingHandler{StopChecker: shutdownService},
		aviaHandlers.HandlerFunc{
			Handler: App.Handlers,
			Route:   "/v1",
		},
	)
}

func configureShutdown(http config.HTTP) *shutdown.Service {
	shutdownService := shutdown.NewService()
	go runChiServer(http.ShutdownPort, shutdownService)
	return shutdownService
}

func configureLogging(cfg *config.Logging) *arczap.Logger {
	converted, err := cfg.ToLoggerConfig()
	if err != nil {
		panic(err)
	}
	newLogger, err := aviaLogging.NewLogger(converted)
	if err != nil {
		panic(err)
	}
	logger.SetLogger(newLogger)
	return newLogger
}
