package main

import (
	"time"

	"a.yandex-team.ru/travel/avia/flight_status_receiver/internal/config"
	aviaHandlers "a.yandex-team.ru/travel/avia/library/go/handlers"
	aviaMetrics "a.yandex-team.ru/travel/avia/library/go/metrics"
)

func configureMetrics(conf config.HTTP) {
	metricsRegistry := aviaMetrics.NewAppMetricsRegistry("")
	sharedFlightMetrics := aviaMetrics.NewMetricsStorage(metricsRegistry)
	aviaMetrics.SetGlobalMetrics(sharedFlightMetrics)

	handler := aviaHandlers.NewAppMetricsHandler(metricsRegistry)
	perfMetricsHandler := aviaHandlers.NewPerfMetricsHandler("perf", 5*time.Second)

	go runChiServer(conf.MetricsPort, handler, perfMetricsHandler)
}
