package collectors

import (
	"context"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/avia/flight_status_receiver/pkg"
)

type defaultCollector struct {
	pkg.Decoder
	name string
}

func DefaultCollector(name string, decoder pkg.Decoder) (pkg.Collector, error) {
	if decoder == nil {
		return nil, xerrors.Errorf("cannot create collector: %w", pkg.DecoderIsNilError)
	}
	return defaultCollector{
		decoder,
		name,
	}, nil
}

func (c defaultCollector) Collect(bb []byte, _ context.Context) (pkg.StatusPack, error) {
	var (
		m          pkg.PartnerMessage
		statusPack pkg.StatusPack
		err        error
	)
	err = statusPack.Init()
	if err != nil {
		return statusPack, xerrors.Errorf("<defaultCollector>.Collect: %w", err)
	}

	m, err = c.Decode(bb)
	if err != nil {
		return statusPack, xerrors.Errorf("<defaultCollector>.Collect: %w", pkg.NewDecodingError(err))
	}
	err = m.Validate()
	if err != nil {
		return statusPack, xerrors.Errorf("<defaultCollector>.Collect: %w", pkg.NewValidationError(err))
	}

	statusPack.Statuses, err = m.Normalize()
	if err != nil {
		return statusPack, xerrors.Errorf("<defaultCollector>.Collect: %w", pkg.NewNormalizationError(err))
	}

	statusPack.FillPartnerMessageInfo()

	return statusPack, nil
}

func (c defaultCollector) Name() string {
	return c.name
}
