package collectors

import (
	"encoding/json"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/avia/flight_status_receiver/pkg"
	"a.yandex-team.ru/travel/proto/avia/flight_status"
)

type IdentityStatus struct {
	FlightStatus []*flight_status.FlightStatus
	MessageID    string
	ReceivedAt   int64
}

func IdentityCollectorP() pkg.Collector {
	if c, err := DefaultCollector(Status, pkg.DecoderFunc(IdentityDecoder)); err != nil {
		panic(err)
	} else {
		return c
	}

}

func (s IdentityStatus) Validate() error {
	return nil
}

func (s IdentityStatus) Normalize() ([]*flight_status.FlightStatus, error) {
	return s.FlightStatus, nil
}

func IdentityDecoder(bb []byte) (pkg.PartnerMessage, error) {
	status := IdentityStatus{}
	if err := json.Unmarshal(bb, &status.FlightStatus); err != nil {
		return nil, xerrors.Errorf("IdentityDecoder: %v: %w", string(bb), err)
	}

	return status, nil
}
