package collectors

import (
	"a.yandex-team.ru/travel/avia/flight_status_receiver/pkg"
)

const (
	Status      = "status"
	FlightStats = "flight-stats"
	Aurora      = "aurora"
	OAG         = "oag"
	VariFlight  = "variflight"
)

type CollectorsManager struct {
	Collectors map[string]pkg.Collector
}

func NewCollectorsManagerP() CollectorsManager {
	return CollectorsManager{
		Collectors: map[string]pkg.Collector{
			Status:      IdentityCollectorP(),
			FlightStats: FlightStatsCollectorP(),
			Aurora:      AuroraCollectorP(),
			OAG:         OAGCollectorP(),
			VariFlight:  VariFlightCollectorP(),
		},
	}
}
