package config

import (
	"context"
	"fmt"
	"math/rand"
	"os"
	"strings"

	"github.com/heetch/confita"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type Config struct {
	HTTP      HTTP
	Logging   Logging
	Logbroker Logbroker
	Deploy    Deploy
}

func NewConfig() Config {
	c := Config{
		HTTP{
			AppPort:      8000,
			ProfilerPort: 8080,
			MetricsPort:  8090,
			ShutdownPort: 9002,
		},
		Logging{
			LogLevel: log.InfoString,
		},
		Logbroker{
			Endpoint:     "logbroker.yandex.net",
			StatusTopics: []string{"/avia/development/flight-status/status"},
			RawDataTopic: "/avia/development/flight-status/partner-message",
		},
		Deploy{},
	}

	loader := confita.NewLoader()
	if err := loader.Load(context.Background(), &c); err != nil {
		logger.Logger().Fatal("Cannot read config", log.Error(err))
	}

	c.Logbroker.SourceID = strings.Join([]string{
		c.Deploy.DeployStageID,
		c.Deploy.DeployPodPersistentFqdn,
		fmt.Sprintf("pid-%d", os.Getpid()),
		fmt.Sprintf("%d", rand.Intn(10)),
	}, ".")
	logger.Logger().Info("Logbroker source ID", log.Any("source id", c.Logbroker.SourceID))

	return c
}
