package config

import (
	"path"

	"a.yandex-team.ru/library/go/core/log"
	aviaLogging "a.yandex-team.ru/travel/avia/library/go/logging"
)

type Logging struct {
	LogLevel       string `config:"AVIA_LOG_LEVEL"`
	LogPath        string `config:"AVIA_LOG_PATH"`
	SentryDSN      string `config:"AVIA_SENTRY_DSN"`
	AppLogFileName string
}

func (l *Logging) ToLoggerConfig() (*aviaLogging.Config, error) {
	level, err := log.ParseLevel(l.LogLevel)
	if err != nil {
		return nil, err
	}
	var sentryConfig *aviaLogging.SentryLoggingConfig
	if l.SentryDSN != "" {
		sentryConfig = &aviaLogging.SentryLoggingConfig{DSN: l.SentryDSN}
	}
	var fileConfig *aviaLogging.FileLoggingConfig
	if l.LogPath != "" && l.AppLogFileName != "" {
		fileConfig = &aviaLogging.FileLoggingConfig{FilePath: path.Join(l.LogPath, l.AppLogFileName)}
	}
	return &aviaLogging.Config{
		Level:               level,
		StdoutLoggingConfig: &aviaLogging.StdoutLoggingConfig{},
		FileLoggingConfig:   fileConfig,
		SentryLoggingConfig: sentryConfig,
	}, nil
}
