package delivery

import (
	"context"
	"encoding/json"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type StdoutDelivery struct {
}

func (s StdoutDelivery) String() string {
	return "stdout"
}

func (s StdoutDelivery) Deliver(ss interface{}, _ context.Context) error {
	bb, err := json.Marshal(ss)
	if err != nil {
		return err
	}
	logger.Logger().Debug("Wrote status", log.String("status", string(bb)))
	return nil
}
