package handlers

import (
	"net/http"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/avia/shared_flights/lib/go/logger"
)

type StopChecker interface {
	IsStopped() bool
}

type PingHandler struct {
	StopChecker StopChecker
}

func (h PingHandler) GetRoute() string {
	return "/ping"
}

func (h PingHandler) ServeHTTP(writer http.ResponseWriter, _ *http.Request) {
	if h.StopChecker != nil && h.StopChecker.IsStopped() {
		h.pingResponse(writer, http.StatusGone, "Application is shutting down")
		return
	}
	h.pingResponse(writer, http.StatusOK, "OK")
}

func (h PingHandler) pingResponse(writer http.ResponseWriter, code int, reason string) {
	writer.WriteHeader(code)
	if _, err := writer.Write([]byte(reason)); err != nil {
		logger.Logger().Error("Ping failed", log.Error(err))
	}
}
