package metrics

import (
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/library/go/core/metrics/solomon"
	aviaMetrics "a.yandex-team.ru/travel/avia/library/go/metrics"
)

var (
	pipelineDurationBuckets = metrics.MakeExponentialDurationBuckets(time.Millisecond, 1.25, 50)
)

func IncrementPipelineFailure(name string) {

	counter := aviaMetrics.
		GlobalMetrics().
		CounterVec(PipelinePrefix, PipelineFailure, []string{"pipeline"}).
		With(map[string]string{
			"pipeline": name,
		})
	solomon.Rated(counter)
	counter.Inc()
}

func IncrementPipelineSuccess(name string) {
	counter := aviaMetrics.
		GlobalMetrics().
		CounterVec(PipelinePrefix, PipelineSuccess, []string{"pipeline"}).
		With(map[string]string{
			"pipeline": name,
		})
	solomon.Rated(counter)
	counter.Inc()
}

func AddDataReceived(name string, size int64) {
	counter := aviaMetrics.
		GlobalMetrics().
		CounterVec(PipelinePrefix, PipelineDataSize, []string{"pipeline"}).
		With(map[string]string{
			"pipeline": name,
		})
	solomon.Rated(counter)
	counter.Add(size)
}

func WritePipelineDuration(name string, duration time.Duration) {
	aviaMetrics.GlobalMetrics().
		TimerVec(PipelinePrefix, PipelineDuration, []string{"pipeline"}).
		With(map[string]string{
			"pipeline": name,
		}).RecordDuration(duration)

	hist := aviaMetrics.GlobalMetrics().
		RatedHistogramVec(PipelinePrefix, PipelineTimings, pipelineDurationBuckets, []string{"pipeline"}).
		With(map[string]string{
			"pipeline": name,
		})
	solomon.Rated(hist)
	hist.RecordDuration(duration)
}
