package pipeline

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/avia/flight_status_receiver/internal/collectors"
	"a.yandex-team.ru/travel/avia/flight_status_receiver/pkg"
)

type PipelineManager struct {
	pipelines map[string]pkg.Pipeline
}

//NewPipelineManager registers pipelines for partners
func NewPipelineManagerP(manager collectors.CollectorsManager, statusDelivery pkg.Delivery, rawDataDelivery pkg.Delivery) pkg.PipelineManager {
	pm := PipelineManager{
		make(map[string]pkg.Pipeline),
	}

	for name, collector := range manager.Collectors {
		if err := pm.RegisterPipeline(name, DefaultPipelineP(collector, statusDelivery, rawDataDelivery)); err != nil {
			panic(err)
		}
	}

	return pm
}

func (p PipelineManager) RegisterPipeline(partner string, pipeline pkg.Pipeline) error {
	if pipeline == nil {
		return xerrors.Errorf("cannot register pipeline: %w", pkg.PipelineIsNilError)
	}
	p.pipelines[partner] = pipeline
	return nil
}

func (p PipelineManager) Pipeline(partner string) (pkg.Pipeline, error) {
	v, ok := p.pipelines[partner]
	if !ok {
		return nil, xerrors.Errorf("pipeline for partner %v not found: %w", partner, pkg.NoSuchPipelineError)
	}
	return v, nil
}
